//
//  MyScene.m
//  iPhone_SpriteKitDemo
//
//  Created by Rene on 20/11/13.
//  Copyright (c) 2013 i10. All rights reserved.
//

#import "MyScene.h"

static const NSString *asteroidString   = @"asteroid";
static const NSString *shotString       = @"shot";

static const uint32_t noneCategory         =  0;
static const uint32_t asteroidCategory     =  0x1 << 0;
static const uint32_t shotCatergory        =  0x1 << 1;
static const uint32_t spaceshipCategory    =  0x1 << 2;
static const uint32_t allCategory          =  UINT32_MAX;

@implementation MyScene

#pragma mark -
#pragma mark game setup

-(id)initWithSize:(CGSize)size {
    if (self = [super initWithSize:size]) {
        
        screenHeight = self.size.height;
        screenWidth = self.size.width;
        
        self.physicsWorld.gravity = CGVectorMake(0,0); // no gravity
        self.physicsWorld.contactDelegate = self; // inform scene on contact
        
        
        [self setUpBackground];
        [self setUpSpaceShip];
        
        // start asteroid spawning
        [NSTimer scheduledTimerWithTimeInterval: 2
                                         target: self
                                       selector: @selector(placeRandomAsteroid)
                                       userInfo: nil
                                        repeats: YES];
        
        
        // start permanent shooting
        [NSTimer scheduledTimerWithTimeInterval: 1
                                         target: self
                                       selector: @selector(placeNewShot)
                                       userInfo: nil
                                        repeats: YES];
        
        
    }
    return self;
}

// -----------------------------------------------------------------------------------------------------------------
-(void) setUpBackground
// -----------------------------------------------------------------------------------------------------------------
{
    
    // Background Variante A - static Background (no copyrights on picture)
    // -----------------------------------------------------------------------------------------------------------------
    
    /*
     // adding the background
     SKSpriteNode *background    = [SKSpriteNode spriteNodeWithImageNamed: @"moonBackround.jpg"];
     background.position         = CGPointMake(CGRectGetMidX(self.frame), CGRectGetMidY(self.frame));
     [self addChild:background];
     
     */
    
    // -----------------------------------------------------------------------------------------------------------------
    
    
    // Background Variante B - simulated movement
    // -----------------------------------------------------------------------------------------------------------------
    
    
    SKSpriteNode *background    = [SKSpriteNode spriteNodeWithColor: [SKColor colorWithRed: 0.75  green: 0.75  blue: 0.75  alpha: 1] size: self.size];
    background.position         = CGPointMake(CGRectGetMidX(self.frame), CGRectGetMidY(self.frame));
    background.zPosition = 0;
    [self addChild:background];
    
    // add some initial craters
    [self placeCraterAtPosition: CGPointMake(screenWidth / 2, screenHeight / 3)];
    [self placeCraterAtPosition: CGPointMake(screenWidth / 4 * 3, screenHeight / 2)];
    [self placeCraterAtPosition: CGPointMake(screenWidth / 3 , screenHeight / 4 * 3)];
    
    [NSTimer scheduledTimerWithTimeInterval: 5
                                     target: self
                                   selector: @selector(placeRandomCrater)
                                   userInfo: nil
                                    repeats: YES];
    
    
    // -----------------------------------------------------------------------------------------------------------------
}

// -----------------------------------------------------------------------------------------------------------------
-(void) setUpSpaceShip
// -----------------------------------------------------------------------------------------------------------------
{
    // adding the airplane
    self.spaceship              = [SKSpriteNode spriteNodeWithImageNamed:@"Spaceship"];
    self.spaceship.scale        = 0.1;
    self.spaceship.zPosition    = 2;
    self.spaceship.position     = CGPointMake(screenWidth / 2, 30 + self.spaceship.size.height / 2);
    [self addChild: self.spaceship];
    
    // add thrust to spaceship
    NSString *path          = [[ NSBundle mainBundle] pathForResource:@"thrust" ofType: @"sks"];
    SKEmitterNode *thrust   = [NSKeyedUnarchiver unarchiveObjectWithFile:path];
    thrust.position         = CGPointMake(0  , -5 * self.spaceship.size.height ); // WTF - why * 5 ???
    [self.spaceship addChild: thrust];
}

#pragma mark -
#pragma mark event processing

-(void) touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
    if (touches.count == 1) {
        for (UITouch *touch in touches) {
            
            // Variante A - moving by action
            // -----------------------------------------------------------------------------------------------------------------
            
            /*
             
             if (self.spaceship.position.x > screenWidth) {
             self.spaceship.position = CGPointMake(screenWidth, self.spaceship.position.y);
             } else if (self.spaceship.position.x < 0) {
             self.spaceship.position = CGPointMake(0, self.spaceship.position.y);
             }
             
             CGPoint prevPos = [touch previousLocationInNode: self];
             CGPoint location = [touch locationInNode: self];
             
             float moveDistance = (location.x - prevPos.x) * 1.5;
             
             if (self.spaceship.position.x + moveDistance > screenWidth) {
             moveDistance = screenWidth - self.spaceship.position.x;
             } else if (self.spaceship.position.x + moveDistance < 0) {
             moveDistance = 0 - self.spaceship.position.x;
             }
             
             SKAction *move = [SKAction moveByX: moveDistance y:0 duration:0.1];
             [self.spaceship runAction: move];
             
             */
            
            // -----------------------------------------------------------------------------------------------------------------
            
            // Variante B - moving by set
            // -----------------------------------------------------------------------------------------------------------------
            
            CGPoint location = [touch locationInNode: self];
            
            int newXPos = ((location.x - (screenWidth / 2)) * 1.5) + (screenWidth / 2);
            
            newXPos = MAX(0, newXPos);
            newXPos = MIN(screenWidth, newXPos);
            
            self.spaceship.position = CGPointMake(newXPos, self.spaceship.position.y);
            
            
        }
    }
}

// -----------------------------------------------------------------------------------------------------------------
-(void)didBeginContact:(SKPhysicsContact *)contact
// -----------------------------------------------------------------------------------------------------------------
{
    if (contact.bodyA.node.name == shotString && contact.bodyB.node.name == asteroidString)
    {
        [contact.bodyA.node removeFromParent];
        
        [self placeExplosionAtPosition: contact.contactPoint];
        
    } else if (contact.bodyB.node.name == shotString && contact.bodyA.node.name == asteroidString) {
        
        [contact.bodyB.node removeFromParent];
        
        [self placeExplosionAtPosition: contact.contactPoint];
    }
}

#pragma mark -
#pragma mark object placement

// -----------------------------------------------------------------------------------------------------------------
-(void) placeExplosionAtPosition: (CGPoint) position
// -----------------------------------------------------------------------------------------------------------------
{
    NSString *path              = [[ NSBundle mainBundle] pathForResource:@"explosion" ofType: @"sks"];
    SKEmitterNode *explosion    = [NSKeyedUnarchiver unarchiveObjectWithFile:path];
    explosion.position          =  position;
    explosion.scale             = 0.1;
    [self addChild: explosion];
}

// -----------------------------------------------------------------------------------------------------------------
-(void) placeRandomAsteroid
// -----------------------------------------------------------------------------------------------------------------
{
    int xPos = arc4random_uniform(screenWidth);
    CGPoint position = CGPointMake (xPos  , screenHeight);
    
    int acc = -10 + -1 *  arc4random_uniform(arc4random_uniform(100));
    CGVector speed = CGVectorMake(0, acc);
    
    [self placeNewAsteroidAtPosition: position withSpeed: speed];
}

// -----------------------------------------------------------------------------------------------------------------
-(void) placeNewAsteroidAtPosition: (CGPoint) position withSpeed: (CGVector) speed
// -----------------------------------------------------------------------------------------------------------------
{
    SKSpriteNode *asteroid  = [SKSpriteNode spriteNodeWithImageNamed:@"asteroid2.png"];
    
    asteroid.scale = 0.1;
    asteroid.position =  position;
    asteroid.physicsBody = [SKPhysicsBody bodyWithCircleOfRadius: asteroid.size.width / 2 ];
    asteroid.name = asteroidString.copy;
    asteroid.physicsBody.mass = 10;
    asteroid.physicsBody.linearDamping = 0;
    asteroid.zPosition = 2;
    asteroid.physicsBody.contactTestBitMask = shotCatergory;
    
    [self addChild: asteroid];
    
    asteroid.physicsBody.velocity = speed;
}

// -----------------------------------------------------------------------------------------------------------------
-(void) placeRandomCrater
// -----------------------------------------------------------------------------------------------------------------
{
    int xPos = arc4random_uniform(screenWidth);
    CGPoint position = CGPointMake (xPos  , screenHeight);
    
    [self placeCraterAtPosition: position];
}

// -----------------------------------------------------------------------------------------------------------------
-(void) placeCraterAtPosition: (CGPoint) position
// -----------------------------------------------------------------------------------------------------------------
{
    
    SKSpriteNode *crater  = [SKSpriteNode spriteNodeWithImageNamed:@"crater.jpg"];
    double scale        = arc4random_uniform(20) * 0.01;
    crater.scale        = scale;
    crater.position     =  position;
    crater.zPosition    = 1;
    [self addChild: crater];
    
    SKAction *craterMove = [SKAction moveByX: 0 y: -20 duration: 1];
    [crater runAction:[SKAction repeatActionForever:craterMove]];
    
}

// -----------------------------------------------------------------------------------------------------------------
- (void) placeNewShot
// -----------------------------------------------------------------------------------------------------------------
{
    
    SKSpriteNode *shot = [SKSpriteNode spriteNodeWithColor:[SKColor clearColor] size: CGSizeMake(10, 10)];
    shot.name = shotString.copy;
    
    shot.position = CGPointMake(self.spaceship.position.x,
                                self.spaceship.position.y + self.spaceship.size.height / 2);
    
    shot.physicsBody = [SKPhysicsBody bodyWithCircleOfRadius: shot.size.width / 2];
    shot.physicsBody.mass = 5;
    shot.physicsBody.linearDamping = 0;
    shot.physicsBody.contactTestBitMask = asteroidCategory;
    shot.physicsBody.collisionBitMask = asteroidCategory;
    shot.zPosition = 2;
    
    NSString *path = [[ NSBundle mainBundle] pathForResource:@"fireShot" ofType: @"sks"];
    SKEmitterNode *shotParticle = [NSKeyedUnarchiver unarchiveObjectWithFile: path];
    shotParticle.scale = 0.5;
    [shot addChild: shotParticle];
    
    [self addChild: shot];
    
    shot.physicsBody.velocity = CGVectorMake(0, 100);
    
}


@end
